import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns
from decision_company import read_csv_file, corr, create_figure, show_plots, set_plot_title, save_plot, create_heatmap

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")   
  
# Create a correlation matrix  
corr_matrix = corr(credit_customers)  
create_figure((12, 10))  
create_heatmap(corr_matrix, annot=True, cmap='coolwarm')  
set_plot_title("Correlation Matrix")  
save_plot('ref_result/Correlation_Matrix.png')  
show_plots()  